const express = require('express');
const app = express();
const PORT = 3000;

// Log some information for any requests
app.use(function(req, res, next) {
	console.log(req.method);
	console.log(req.url);
	console.log(req.query);
	console.log("Body:  ", req.body); // req.body is a JavaScript object
	next();  // go to the next registered handler/middleware
});

// Log the date and time
app.use(function(req, res, next) {
  const now = new Date();
  console.log(`[${now.toLocaleString()}] ${req.method} ${req.url}`);
  next(); // go to the next registered handler/middleware
});

// Log the number of requests handled so far
let requestCount = 0;
app.use(function(req, res, next) {
  requestCount++;
  console.log("Request count = " + requestCount);
  next(); // go to the next registered handler/middleware
});

// Serve all files
app.use(express.static(__dirname));

// Start server
app.listen(PORT);
console.log(`Server is listening at http://localhost:${PORT}`);